
class WorkingHoursModel {
  String? day;
  List<Timeslot>? timeslot;

  WorkingHoursModel({this.day, this.timeslot});

  WorkingHoursModel.fromJson(Map<String, dynamic> json) {
    day = json['day'];
    if (json['timeslot'] != null) {
      timeslot = <Timeslot>[];
      json['timeslot'].forEach((v) {
        timeslot!.add(new Timeslot.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['day'] = this.day;
    if (this.timeslot != null) {
      data['timeslot'] = this.timeslot!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Timeslot{
  String? from;
  String? to;


  String? date;

  Timeslot({this.from, this.to,});

  Timeslot.fromJson(Map<String, dynamic> json) {
    from = json['from'];
    to = json['to'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['from'] = this.from;
    data['to'] = this.to;
    return data;
  }

}
